import UIKit

/*
 * Assignment Operator
 */

let x = 4
var y = 3
print("x is \(x) and y is \(y)")
y = x // y has the value of 4
print("y is changed to \(y)")

/* Tuple Constant */

let (k, h) = (2, 4) // k has a value of 2 and h has a value of 4
print("k is \(k) and h is \(h)")

/*
 * Arithmetic Operators
 */

let i = 3, j = 6
print("i is \(i) and j is \(j)")

let addition = i + j // 9
print("i + j = \(addition)")

let subtraction = j - i // 3
print("j - i = \(subtraction)")

let multiplication = i * j // 18
print("i * j = \(multiplication)")

let division = Double(j)/Double(i) // 2.0
print("j / i = \(division)")

/* String concatenation */

let hello = "Hello"
let world = "World"
let concatenation = hello + " " + world + "!"
print(concatenation)

/*
 * Remainder Operator
 */

let seven = 7
let two = 2
let remainder = seven % two // 1
print("\(seven) % \(two) = \(remainder)")

/*
 * Compound Assignment Operators
 */

var x1 = 10 // x1 = 10
print("x1 is \(x1)")
x1 += 9 // x1 = 19
print("x1 is now \(x1)")

/*
 * Comparison Operators
 */

var value1 = (19, "ios")
var value2 = (20, "android")
var isComparisonTrue = value1 < value2
/* evaluates to true because 19 is compared to 20 and 19 is indeed less than 20, the second values are not compared */
print("\(value1) < \(value2) = \(isComparisonTrue)")

value1 = (21, "application")
value2 = (21, "development")
isComparisonTrue = value1 < value2
/* evaluates to true because 21 is equal to 21 and "application" is indeed less than "development" */
print("\(value1) < \(value2) = \(isComparisonTrue)")
 
value1 = (22, "mobile")
value2 = (22, "mobile")
isComparisonTrue = value1 == value2
/* evaluates to true because 22 is equal to 22 and "mobile" is equal to "mobile" */
print("\(value1) == \(value2) = \(isComparisonTrue)")

/*
 * Ternary Conditional Operator
 */

let isRaining = false
isRaining ? print("It’s raining") : print("It’s not raining")

/* shorthand for */

if isRaining {
   print("It’s raining")
} else {
   print("It’s not raining")
}

/*
 * Nil-Coalescing Operator
 */

let favoriteFruit = "Pineapple"
var fruit: String? // fruit is assigned to nil
var output = fruit ?? favoriteFruit
print("output is \(output)")

/* shorthand for */
output = (fruit == nil) ? favoriteFruit : fruit!
print("output is \(output)")

fruit = "apple"
output = fruit ?? favoriteFruit
print("output is \(output)")

/*
 * Closed Range Operator (x...y)
 */

for i in 1...12 {
    print("\(i) x 2 = \(i * 2)")
}

/*
 * Half-Open Range Operator (x..<y)
 */

for j in 1..<13 {
    print("\(j) x 3 = \(j * 3)")
}

/*
 * One-Sided Range Operator (...y) or (x...)
 */

// an array of String type
let names = ["Michael", "Lincoln", "Sara", "Sucre"]

// range 0 - 1
for name in names[...1] {
    print("name is \(name)")
}

// range 2 - 3
for name in names[2...] {
    print("name is \(name)")
}

/*
 * Logical NOT Operator
 */

var isSunny = false // isSunny has the value false
print("isSunny is \(isSunny)")
isSunny = !isSunny // isSunny has the value true
print("isSunny is \(isSunny)")

/*
 * Logical AND Operator
 */

let isCorrectPin = true
let isCorrectFaceID = false
 
if isCorrectPin && isCorrectFaceID {
   print("Authentication successful!")
} else {
   print("Authentication failed!")
}

/*
 * Logical OR Operator
 */

if isCorrectPin || isCorrectFaceID {
   print("Authentication successful!")
} else {
   print("Authentication failed!")
}
