import UIKit

/*
 * Collection Types
 */

/* Creating an Empty Array */

var numbers = [Int]() // empty array
print("count of numbers is \(numbers.count)")
numbers.append(15) // array has 1 value where numbers now become [15]
print("numbers is now \(numbers)")
numbers = [] // setting the array back to empty
print("count of numbers is back to \(numbers.count)")

/* Creating an Array with a Default Value */

let points = Array(repeating: 0.0, count: 2)
print("points is \(points)")

/* Creating an Array by Adding Two Arrays Together */

let coordinates = Array(repeating: 3.3, count: 2)
let result = points + coordinates
print("result is \(result)")

/* Creating an Array with an Array Literal */

var groceryList = ["Fruits", "Yogurt", "Vegetables"]
print(groceryList)

/* Accessing and Modifying an Array */
print("groceryList contain \(groceryList.count) items") // groceryList.count returns 3

if groceryList.isEmpty {
    print("No need to go to the supermarket")
} else { // groceries is not empty therefore groceryList.isEmpty returns false
    print("Need to buy groceries")
}

groceryList.append("Bread")
print(groceryList)

groceryList += ["Milk", "Coffee", "Tea"]
print(groceryList)

var firstItem = groceryList[0]
print("First item is \(firstItem)")

groceryList[0] = "Apple"
firstItem = groceryList[0]
print(firstItem)

groceryList[2...4] = ["Broccoli", "Carrot"]
print(groceryList)

groceryList.insert("Kiwi", at: 0)
print(groceryList)

groceryList.remove(at: 0)
print(groceryList)

groceryList.removeLast()
print(groceryList)

/* Iterating Over an Array */

for item in groceryList {
    print("item is \(item)")
}

for (index, value) in groceryList.enumerated() {
    print("item at \(index) is \(value)")
}

/* Creating and Initializing an Empty Set */

var alphabets = Set<Character>() // empty set
print("count of alphabets is \(alphabets.count)")
alphabets.insert("a") // set has 1 value where alphabets now become ["a"]
print("alphabets is now \(alphabets)")
alphabets = [] // setting the set back to empty
print("count of alphabets is back to \(alphabets.count)")

/* Creating a Set with an Array Literal */

var favoriteTvShows: Set = ["Charmed", "Prison Break", "Money Heist"]
print("Favorite TV Shows are \(favoriteTvShows)")

/* Accessing and Modifying a Set */

print("favoriteTvShows contain \(favoriteTvShows.count) items") // favoriteTvShows.count returns 3

if favoriteTvShows.isEmpty {
    print("I like most of the popular tv shows")
} else { // favoriteTvShows is not empty therefore favoriteTvShows.isEmpty returns false
    print("I have some favorite tv shows")
}

favoriteTvShows.insert("The Flash")
print(favoriteTvShows)

if let removedTvShow = favoriteTvShows.remove("Charmed") {
    print("I have watched \(removedTvShow) too many times")
} else {
    print("Tv show 'Charmed' is not in my favorite tv show set")
}

if favoriteTvShows.contains("Prison Break") {
    print("I have reached Season 3")
} else {
    print("I have watched all the seasons of my favorite tv shows")
}

/* Iterating Over a Set */

for favoriteTvShow in favoriteTvShows {
    print(favoriteTvShow)
}

for favoriteTvShow in favoriteTvShows.sorted() {
    print(favoriteTvShow)
}

/* Performing Set Operations */

let evenNumbers: Set = [2, 4, 6, 8, 10]
let oddNumbers: Set = [1, 3, 5, 7, 9]
let primeNumbers: Set = [2, 3, 5, 7]

let intersectionEvenPrimeNumbers = evenNumbers.intersection(primeNumbers)
print("The intersection of the even numbers \(evenNumbers.sorted()) with the prime numbers \(primeNumbers.sorted()) is \(intersectionEvenPrimeNumbers.sorted())")

let symmeticDifferenceOddPrimeNumbers = oddNumbers.symmetricDifference(primeNumbers)
print("The symmetric difference of the odd numbers \(oddNumbers.sorted()) with the prime numbers \(primeNumbers.sorted()) is \(symmeticDifferenceOddPrimeNumbers.sorted())")

let unionEvenOddNumbers = evenNumbers.union(oddNumbers)
print("The union of the even numbers \(evenNumbers.sorted()) with the odd numbers \(oddNumbers.sorted()) is \(unionEvenOddNumbers.sorted())")

let subtractingOddPrimeNumbers = oddNumbers.subtracting(primeNumbers)
print("The subtracting of the odd numbers \(oddNumbers.sorted()) with the prime numbers \(primeNumbers.sorted()) is \(subtractingOddPrimeNumbers.sorted())")

/* Set Membership and Equality */

let numberSet: Set = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
let sortedSet = numberSet.sorted()

if unionEvenOddNumbers.sorted() == sortedSet {
    print("numberSet \(sortedSet) is equal to union of the even numbers \(unionEvenOddNumbers)")
}

if numberSet.isSubset(of: unionEvenOddNumbers) {
    print("numberSet \(sortedSet) are subset of \(unionEvenOddNumbers.sorted())")
}

if unionEvenOddNumbers.isSuperset(of: numberSet) {
    print("unionEvenOddNumbers \(unionEvenOddNumbers.sorted()) is the superset of the odd numbers \(sortedSet)")
}

if primeNumbers.isStrictSubset(of: numberSet) {
    print("primeNumbers \(primeNumbers.sorted()) is strict subset of \(sortedSet)")
}

if numberSet.isStrictSuperset(of: evenNumbers) {
    print("numberSet \(sortedSet) is strict superset of \(evenNumbers.sorted())")
}

let randomNumbers: Set = [11, 14, 16, 17, 20]

if oddNumbers.isDisjoint(with: randomNumbers) {
    print("oddNumbers \(oddNumbers.sorted()) is disjoint with \(randomNumbers.sorted())")
}

/* Creating an Empty Dictionary */

var records = [Int: String]() // empty dictionary
print("count of records is \(records.count)")
records[1] = "Swift" // dictionary has 1 key-value where records now become [1: "Swift"]
print("records is now \(records)")
records = [:] // setting the dictionary back to empty
print("count of records is back to \(records.count)")

/* Creating a Dictionary with a Dictionary Literal */

var countries = ["US": "United States of America", "UK": "United Kingdom", "FR": "France", "MU": "Mauritius"]
print(countries)

/* Accessing and Modifying a Dictionary */

print("countries contain \(countries.count) items") // countries.count returns 4

if countries.isEmpty {
    print("No countries found")
} else { // countries is not empty therefore countries.isEmpty returns false
    print("Some countries found")
}

countries["AU"] = "Australia"
countries["CA"] = "CA"
countries["GR"] = "GR"
print(countries)

countries["CA"] = "Canada"
countries.updateValue("Greece", forKey: "GR")
print("Updated \(countries["CA"] ?? "") and \(countries["GR"] ?? "")")

if let retrievedValue = countries["MU"] {
    print("\(retrievedValue)'s country code is MU")
} else {
    print("No such key was found")
}

countries["CA"] = nil
print("Removed Canada \(countries)")

if let removedValue = countries.removeValue(forKey: "AU") {
    print("\(removedValue) has been removed from \(countries)")
} else {
    print("No such key was found")
}

/* Iterating Over a Dictionary */

for (countryCode, country) in countries {
    print("Code \(countryCode) is for \(country)")
}

for code in countries.keys {
    print("Code is \(code)")
}

for country in countries.values {
    print("Country is \(country)")
}

