import UIKit

/*
 * Enumerations
 */

enum DayOfWeek {
    case monday
    case tuesday
    case wednesday
    case thursday
    case friday
    case saturday
    case sunday
}

print(DayOfWeek.monday)

enum MonthOfYear {
    case january, february, march, april, may, june, july, august, september, october, november, december
}

var month = MonthOfYear.september
month = .october

print(month)

/**
 * Matching Enumeration Values with a Switch Statement
 */

switch month {
case .december:
    print("This year is ending pretty soon")
default:
    print("We still got some months before new year")
}

/**
 * Iterating over Enumeration Cases
 */

enum Supermarket : CaseIterable {
    case intermart, jumbo, winners
}

let supermarkets = Supermarket.allCases

for supermarket in supermarkets {
    print(supermarket)
}

/**
 * Associated Values
 */

enum PaymentMethod {
    case cash
    case bank(String)
}

var paymentMethod = PaymentMethod.cash
print(paymentMethod)
paymentMethod = .bank("00002345789")
print(paymentMethod)

switch paymentMethod {
case .cash:
    print("No value")
case .bank(let accountNumber):
    print("Bank Account Number: \(accountNumber)")
}

paymentMethod = .cash

switch paymentMethod {
case .cash:
    print("No value")
case let .bank(accountNumber):
    print("Bank Account Number: \(accountNumber)")
}

/**
 * Raw Values
 */

enum DayNumber: Int {
    case monday = 1, tuesday, wednesday, thursday, friday, saturday, sunday
}

let chosenDay = DayNumber.friday
print(chosenDay.rawValue)

/**
 * Recursive Enumerations
 */

enum TypographyExpression {
    case text(String)
    indirect case uppercase(TypographyExpression)
    indirect case lowercase(TypographyExpression)
}

func changeTypography(_ expression: TypographyExpression) -> String {
    switch expression {
    case let .text(value):
        return value
    case let .uppercase(text):
        return changeTypography(text).uppercased()
    case let .lowercase(text):
        return changeTypography(text).lowercased()
    }
}

var myName = "Zakhia"
var expression = TypographyExpression.uppercase(TypographyExpression.text(myName))
myName = changeTypography(expression)
print(myName)
expression = .lowercase(expression)
myName = changeTypography(expression)
print(myName)
