import UIKit

/*
 * Functions
 */

func calculateSum(numbers: [Int])  -> Int {
    var sum = 0

    for number in numbers {
        sum+=number
    }

    return sum
}

print(calculateSum(numbers: [2, 4, 6, 8, 10]))

// function with no parameter which returns a String

func getDefaultText() -> String {
    return "Hello World!"
}

print(getDefaultText())

// function with one parameter a String which has no return type

func getText(name: String) {
    print("Hello \(name)!")
}

getText(name: "Zakhia")

func getSumAndAverage(numbers: [Double]) -> (sum: Double, average: Double) {
    var sum = 0.0

    for number in numbers {
        sum+=number
    }
    
    let average = sum / Double(numbers.count)
    
    return (sum, average)
}

let numbers = [3.0, 6.0, 9.0, 12.0, 15.0]
let sumAndAverage = getSumAndAverage(numbers: numbers)
print("Sum of \(numbers) is \(sumAndAverage.sum) and average is \(sumAndAverage.average)")

/**
 * Implicit Return
 */

func getDefaultText2() -> String {
    "Hello World!"
}

print(getDefaultText2())

/**
 * Function Argument Labels and Parameter Names
 */

// function with parameter name & argument label (year)
func getAge(year: Int) -> Int {
    let currentYear = Calendar.current.component(.year, from: Date())
    return currentYear - year
}

// function with explicit argument label (for) and parameter name (year)
func getAge(for year: Int) -> Int {
    getAge(year: year)
}

var year = 1993
var age = getAge(year: year)

print("If year born is \(year) then your age must be \(age) this year")

year = 1964
age = getAge(for: year)

print("If year born is \(year) then your age must be \(age) this year")

/**
 * Omitting Argument Labels
 */

// function omitted the argument label
func getAge(_ year: Int) -> Int {
    getAge(for: year)
}

year = 1983
age = getAge(year)

print("If year born is \(year) then your age must be \(age) this year")

/**
 * Default Parameter Values
 */

func greetUser(name: String = "there") -> String {
    "Hi \(name)!"
}

print(greetUser())
print(greetUser(name: "Zakhia"))

/**
 * Variadic Parameters
 */

func calculateSum(numbers: Int...) -> Int {
    calculateSum(numbers: numbers)
}

print(calculateSum(numbers: 1, 2, 3, 4, 5, 6))

/**
 * In-Out Parameters
 */

var output = calculateSum(numbers: 34, 45, 65, 70, 98, 100)

func getAverage(of value: inout Int, count: Int) {
    value = value / count
}

getAverage(of: &output, count: 6)
print(output)

/**
 * Function Types
 */

func getSum(_ x: Int, _ y: Int) -> Int {
    x + y
}

func getAverage(_ x: Int, _ y: Int) -> Int {
    (x + y) / 2
}

func displayWelcome() {
    print("Welcome")
}

var x = 25
var y = 80
let sum = getSum(x, y)
let average = getAverage(x, y)

print("Sum of \(x) and \(y) is \(sum) and its average is \(average)")
displayWelcome()

/**
 * Using Function Types
 */

x = 55
y = 115
var computationalFunction: (Int, Int) -> Int = getSum

print("computationFunction outputs \(computationalFunction(x, y))")

x = 77
y = 124
computationalFunction = getAverage

print("computationFunction outputs \(computationalFunction(x, y))")

/**
 * Function Types as Parameter Types
 */

func printOutputOfComputation(a: Int, b: Int, _ compute: (Int, Int) -> Int) {
    print("computationFunction outputs \(compute(a, b))")
}

printOutputOfComputation(a: 167, b: 230, computationalFunction)

/**
 * Function Types as Return Types
 */

func computeAverage(numbers: [Int]) -> Int {
    calculateSum(numbers: numbers) / numbers.count
}

func compute(average: Bool) -> ([Int]) -> Int {
    average ? computeAverage : calculateSum
}

var integers = [12, 24, 36, 48, 54]
var computation = compute(average: false)

print("Sum of \(integers) is \(computation(integers))")
computation = compute(average: true)
print("Average of \(integers) is \(computation(integers))")

/**
 * Nested Functiona
 */

func computeEnclosing(average: Bool) -> ([Int]) -> Int {
    func computeAverageNested(numbers: [Int]) -> Int {
        calculateSum(numbers: numbers) / numbers.count
    }
    
    return average ? computeAverageNested : calculateSum
}

integers = [5, 10, 15, 20, 25, 30, 35, 40]
computation = computeEnclosing(average: false)
print("Sum of \(integers) is \(computation(integers))")
computation = compute(average: true)
print("Average of \(integers) is \(computation(integers))")
