//
//  FruitListController.swift
//  SampleListDisplay
//
//  Created by Princess Zakhia on 26/10/2020.
//

import UIKit

class FruitListController: UITableViewController {
    // 1
    let fruits: [(name: String, image: UIImage?)] = [
        ("Apple", UIImage(named: "icon_apple")), ("Banana", UIImage(named: "icon_banana")), ("Orange", UIImage(named: "icon_orange")), ("Pineapple", UIImage(named: "icon_pineapple")),
        ("Grape", UIImage(named: "icon_grape")), ("Kiwifruit", UIImage(named: "icon_kiwi")), ("Pear", UIImage(named: "icon_pear")), ("Grapefruit", UIImage(named: "icon_grapefruit")),
        ("Peach", UIImage(named: "icon_peach")), ("Apricot", UIImage(named: "icon_apricot")), ("Plum", UIImage(named: "icon_plum")), ("Mango", UIImage(named: "icon_mango")),
        ("Strawberry", UIImage(named: "icon_strawberry")), ("Blueberry", UIImage(named: "icon_blueberry")), ("Raspberry", UIImage(named: "icon_raspberry")), ("Blackberry", UIImage(named: "icon_blackberry")),
        ("Cranberry", UIImage(named: "icon_cranberry")), ("Passionfruit", UIImage(named: "icon_passion_fruit")), ("Watermelon", UIImage(named: "icon_watermelon")),
        ("Cantaloupe", UIImage(named: "icon_cantaloupe")), ("Date Fruit", UIImage(named: "icon_date_fruit")), ("Lemon", UIImage(named: "icon_lemon")), ("Lychee", UIImage(named: "icon_lychee")),
        ("Papaya", UIImage(named: "icon_papaya")), ("Dragonfruit", UIImage(named: "icon_dragon_fruit")), ("Pomegranate", UIImage(named: "icon_pomegranate"))
    ]
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }
    
    // MARK: - Table view data source
    
    // 2
    override func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    // 3
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return fruits.count
    }
    
    // 4
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        guard let cell = tableView.dequeueReusableCell(withIdentifier: "FruitCell", for: indexPath) as? FruitCell
        else { return UITableViewCell() }
        
        let fruit = fruits[indexPath.row]
        cell.lblFruit.text = fruit.name
        
        if let image = fruit.image {
            cell.imgFruit.image = image
        }
        
        return cell
    }
    
}
