import UIKit

/*
 * Deinitialization
 */

class BankAccount {
    static var currentBalance: Double = 0.0
}

class Transaction {
    var currentBalance: Double
    
    init() {
        currentBalance = BankAccount.currentBalance
    }
    
    func depositMoney(_ amount: Double) {
        currentBalance += amount
    }
    
    func withdrawMoney(_ amount: Double) {
        currentBalance -= amount
    }
    
    deinit {
        BankAccount.currentBalance = currentBalance
    }
}

let transaction = Transaction()
print(transaction.currentBalance)

transaction.depositMoney(20000)
print(transaction.currentBalance)

transaction.withdrawMoney(5000)
print(transaction.currentBalance)

