import UIKit

/*
 * Extensions
 */

extension Double {
    var kg: Double {
        return self * 2.20462
    }
    
    var pound: Double {
        return self / 2.20462
    }
}

let convertKgToPound = 65.kg
print("65 kg = \(convertKgToPound) pound")

let convertPoundToKg = 99.208.pound
print("99.208 pound = \(convertPoundToKg) kg")

/**
 * Initializers
 */

struct Size {
    var base: Double = 0.0
    var height: Double = 0.0
}

struct Shape {
    var triangle = Size()
    var parallelogram = Size()
}

extension Shape {
    init(base: Double, area: Double, isTriangle: Bool) {
        var height: Double = area / base
        
        if isTriangle {
            height = height / 0.5
        }
        
        let size = Size(base: base, height: height)
        
        self.init(triangle: isTriangle ? size : Size(), parallelogram: isTriangle ? Size() : size)
    }
    
    var areaOfTriangle: Double {
        return 0.5 * triangle.base * triangle.height
    }
    
    var areaOfParallelogram: Double {
        return parallelogram.base * parallelogram.height
    }
}

var shape = Shape(triangle: Size(base: 14, height: 10))
print("Area of the triangle is \(shape.areaOfTriangle)")

shape = Shape(base: 5, area: 15, isTriangle: false)
print("Height of the parallelogram is \(shape.parallelogram.height)")

/**
 * Methods
 */

extension Int {
    func average() -> Double {
        var sum = 0
        var count = 0
        
        for i in 1...self {
            count += 1
            sum += i
        }
        
        return Double(sum)/Double(count)
    }
    
    mutating func factorial() {
        let n = self
        
        var k = 1
        while k < (n - 1) {
            self = self * (n - k)
            k += 1
        }
    }
}

print(10.average())

var five = 5
five.factorial()
print("5! = \(five)")

/**
 * Subscripts
 */

extension String {
    subscript(index: Int) -> Character {
        var character: Character = self.first ?? "A"
        var countIndex = 0
        
        for i in self.indices {
            if countIndex == index {
                character = self[i]
                break
            }
            
            countIndex += 1
        }
        
        return character
    }
}

let text = "Hello World!"
print(text[6])
