import UIKit

/*
 * Initialization
 */

// structure person
struct SPerson {
    var name: String
    var address: String
    var email: String
    var phone: Int
}

// class person
class CPerson {
    var name: String
    var address: String
    var email: String
    var phone: Int
    
    // initializer
    init(name: String, address: String, email: String, phone: Int) {
        self.name = name
        self.address = address
        self.email = email
        self.phone = phone
    }
}

let sPerson = SPerson(name: "Grace", address: "Middleton", email: "grace@mail.com", phone: 32458799)
let cPerson = CPerson(name: "Hannah", address: "Middleton", email: "hannah@mail.com", phone: 99785423)

print("sPerson's name is \(sPerson.name) and cPerson's name is \(cPerson.name)")

/**
 * Customizing Initialization
 */

struct ConversionToGram {
    var output: Double
    
    // with different argument label and parameter name
    init(withKg value: Double) {
        output = value * 1000.0
    }
    
    // with same argument label and parameter name
    init(mgValue: Double) {
        output = mgValue / 1000.0
    }
    
    // without argument label
    init(_ value: Double) {
        output = value
    }
}

let kgToGram = ConversionToGram(withKg: 15)
let mgToGram = ConversionToGram(mgValue: 2500)

print("15kg = \(kgToGram.output)g and 2500mg = \(mgToGram.output)g")

/**
 * Optional Property Types
 */

class Quiz {
    let question: String
    var answer: String?
    
    init(question: String) {
        self.question = question
    }
}

let quiz = Quiz(question: "What is the capital of Australia?")
quiz.answer = "Canberra"

// '\n' is for outputting on another line
print("\(quiz.question)\n\(quiz.answer ?? "no value found")")

/**
 * Initializer Inheritance and Overriding
 */

enum Brand {
    case Apple, Dell, Lenovo, Asus, HP, Acer, MSI
}

class Computer {
    var size: Double
    var brand: Brand
    
    init(size: Double, brand: Brand) {
        self.size = size
        self.brand = brand
    }
}

class Mac: Computer {
    let hasQuickPreview = true
    let hasMultiTouchGesture = true
    
    init(size: Double) {
        super.init(size: size, brand: .Apple)
    }
}

let macBookPro = Mac(size: 16)
print("MacBook Pro with resolution \(macBookPro.size)-inch, of brand \(macBookPro.brand)")

/**
 * Automatic Initializer Inheritance
 */

class Item {
    var title: String
    
    init(title: String) {
        self.title = title
    }
}

class Task: Item {
    var completed = false
}

let task = Task(title: "Laundry")
task.completed = true

print("\(task.title), completed \(task.completed)")

/**
 * Failable Initializers
 */

class Grocery {
    var item: String
    
    init?(item: String) {
        if item.isEmpty {
            return nil
        }
        
        self.item = item
    }
}

let grocery = Grocery(item: "")

if let object = grocery {
    print("object is \(object.item)")
} else {
    print("grocery is empty")
}

/**
 * Setting a Default Property Value with a Closure or Function
 */

class Multiple {
    var five: [String: Int] = {
        var output = [String: Int]()
        
        for i in 1...12 {
            let multiplication = i * 5
            output["\(i) x 5"] = multiplication
        }
        
        return output
    }()
    
    var six: [String: Int] = {
        var output = [String: Int]()
        
        for i in 1...12 {
            let multiplication = i * 6
            output["\(i) x 6"] = multiplication
        }
        
        return output
    }()
}

let multiple = Multiple()

print(multiple.five)
print(multiple.six)
