import UIKit

/*
 * Properties
 */

/**
 * Stored Properties
 */

struct Person {
    let name: String
    var age: Int
}

var person = Person(name: "Barry", age: 22)
print("\(person.name) is of age \(person.age)")
person.age = 23
print("\(person.name) is of age \(person.age)")

/**
 * Computed Properties
 */

struct SimpleMath {
    var numbers: [Int] = []
    var twoNumbers: (a: Int, b: Int) = (0, 0)
    
    // computed property with getter only
    var sum: Int {
        get {
            var output = 0
            
            for number in numbers {
                output += number
            }
            
            return output
        }
    }
    
    // computed property with getter/setter
    var min: Int {
        get {
            var output = numbers[numbers.count - 1]
            
            for number in numbers {
                if output > number {
                    output = number
                }
            }
            
            return output
        }
        
        set(newNumber) {
            numbers.append(newNumber)
        }
    }
    
    // computed property with getter/setter
    var max: Int {
        get {
            var output = numbers[numbers.count - 1]
            
            for number in numbers {
                if output < number {
                    output = number
                }
            }
            
            return output
        }
        
        // shorthand setter
        set {
            numbers.append(newValue)
        }
    }
    
    // computed property with shorthand getter
    var average: Double {
        get {
            Double(sum)/Double(numbers.count)
        }
    }
    
    // read-only computed property
    var multiplication: Int {
        return twoNumbers.a * twoNumbers.b
    }
}

let numbers = [2, 4, 6, 8, 10]
var simpleMath = SimpleMath(numbers: numbers)

print("Sum of \(numbers) is \(simpleMath.sum)")
print("Minimum number is \(simpleMath.min)")
print("Maximum number is \(simpleMath.max)")
print("Average is \(simpleMath.average)")

simpleMath.min = -2
simpleMath.max = 12

print("Sum of \(simpleMath.numbers) is \(simpleMath.sum)")
print("Minimum number is \(simpleMath.min)")
print("Maximum number is \(simpleMath.max)")
print("Average is \(simpleMath.average)")

let twoNumbers = (14, 25)
simpleMath.twoNumbers = twoNumbers

print("Multiplication of \(twoNumbers) is \(simpleMath.multiplication)")

/**
 * Property Observers
 */

struct Grocery {
    var items: [String] = [] {
        willSet {
            print("\(newValue) will be added")
        }
        
        didSet {
            if oldValue != [] {
                print("\(oldValue) was previously added")
            }
        }
    }
}

var grocery = Grocery()
grocery.items = ["Fruits"]

print("numberList has \(grocery.items)")

var addedItems = grocery.items
addedItems.append("Vegetables")
addedItems.append("Yogurt")
grocery.items = addedItems

print("grocery has \(grocery.items)")
