package com.example.samplelistdisplay

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.DividerItemDecoration
import androidx.recyclerview.widget.DividerItemDecoration.VERTICAL
import com.example.samplelistdisplay.adapter.FruitAdapter
import com.example.samplelistdisplay.data.FruitData
import com.example.samplelistdisplay.databinding.ActivityMainBinding

class MainActivity : AppCompatActivity() {
    private lateinit var binding: ActivityMainBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_main)

        val fruitList = getFruitList()
        val adapter = FruitAdapter(fruitList)

        binding.recyclerViewFruit.adapter = adapter

        val dividerItemDecoration = DividerItemDecoration(this, VERTICAL)
        binding.recyclerViewFruit.addItemDecoration(dividerItemDecoration)
    }

    private fun getFruitList() : List<FruitData> {
        val fruitNames = listOf("Apple", "Banana", "Orange", "Pineapple", "Grape", "Kiwifruit", "Pears", "Grapefruit", "Clementine", "Peach", "Apricot", "Plum", "Mango", "Strawberry", "Blueberry", "Raspberry", "Blackberry", "Cranberry", "Passionfruit", "Watermelons", "Cantaloupe", "Carambola", "Custard-Apple", "Date Fruit", "Guava", "Lemon", "Lychee", "Longan", "Papaya", "Dragonfruit", "Pomegranate", "Tamarind")
        val fruitList = mutableListOf<FruitData>()

        for (i in fruitNames.indices) {
            val id = (i + 1).toLong()
            val name = fruitNames[i]
            val fruit = FruitData(id, name)

            fruitList.add(fruit)
        }

        return fruitList
    }
}