package com.example.samplelogin

import android.os.Bundle
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import com.example.samplelogin.databinding.ActivityMainBinding

class MainActivity : AppCompatActivity() {
    private lateinit var binding: ActivityMainBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_main)

        binding.btnLogin.setOnClickListener { btnLoginDidPressed() }
    }

    private fun btnLoginDidPressed() {
        var message = resources.getString(R.string.alert_login_message, "unknown")
        val email = binding.editEmail.text

        if (email.isNotEmpty() && email.isNotBlank()) {
            message = resources.getString(R.string.alert_login_message, email)
        }

        val alert = AlertDialog.Builder(this)

        alert.setTitle(R.string.alert_login_title)
        alert.setMessage(message)
        alert.setPositiveButton(R.string.alert_login_ok) { _, _ -> }
        alert.create()
        alert.show()
    }
}