//
//  DatabaseHelper.swift
//  SampleToDoList
//
//  Created by Princess Zakhia on 03/11/2020.
//

import UIKit
import CoreData

class DatabaseHelper: NSObject {
    static let shared = DatabaseHelper()
    
    func insert(item: String) {
        let context = AppDelegate().persistentContainer.viewContext
        let entity = NSEntityDescription.insertNewObject(forEntityName: "Task", into: context)
        
        entity.setValue(item, forKey: "item")
        
        do {
            try context.save()
        } catch let error {
            print("Could not save item. Error: \(error.localizedDescription)")
        }
    }
    
    func getAll() -> [NSManagedObject]? {
        let context = AppDelegate().persistentContainer.viewContext
        let request = NSFetchRequest<NSFetchRequestResult>(entityName: "Task")
        
        do {
            return try context.fetch(request) as? [NSManagedObject]
        } catch let error {
            print("Could not fetch items. Error: \(error.localizedDescription)")
        }
        
        return nil
    }

}
