//
//  ToDoListController.swift
//  SampleToDoList
//
//  Created by Princess Zakhia on 03/11/2020.
//

import UIKit

class ToDoListController: UITableViewController {
    var items = [String]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // 3
        loadItems()
    }
    
    // MARK: - IBAction
    
    @IBAction func addDidPressed(_ sender: UIBarButtonItem) {
        showTextField()
    }
    
    private func showTextField() {
        let alertController = UIAlertController(title: "New Item", message: "", preferredStyle: .alert)
        
        alertController.addTextField { (textField) in
            textField.placeholder = "Enter a new item"
        }
        
        let okAction = UIAlertAction(title: "OK", style: .default) { (_) in
            if let textField = alertController.textFields?.first, let newItem = textField.text, !newItem.isEmpty, newItem.count > 0 {
                self.items.append(newItem)
                // 1
                DatabaseHelper.shared.insert(item: newItem)
                self.tableView.reloadData()
            }
            
            alertController.dismiss(animated: true, completion: nil)
        }
        
        let cancelAction = UIAlertAction(title: "Cancel", style: .cancel) { (_) in
            alertController.dismiss(animated: true, completion: nil)
        }
        
        alertController.addAction(okAction)
        alertController.addAction(cancelAction)
        
        present(alertController, animated: true, completion: nil)
    }
    
    // 2
    private func loadItems() {
        if let itemObjs = DatabaseHelper.shared.getAll() {
            for itemObj in itemObjs {
                let item = itemObj.value(forKey: "item") as? String ?? ""
                items.append(item)
            }
        }
        
        tableView.reloadData()
    }
    
    // MARK: - Table view data source
    
    override func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return items.count
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ItemCell", for: indexPath)
        
        let item = items[indexPath.row]
        cell.textLabel?.text = item
        
        return cell
    }
    
    override func tableView(_ tableView: UITableView, commit editingStyle: UITableViewCell.EditingStyle, forRowAt indexPath: IndexPath) {
        if editingStyle == .delete {
            items.remove(at: indexPath.row)
            tableView.reloadData()
        }
    }
}
